
require('dotenv').config();

var database = require('mysql');
var bcrypt = require ('bcrypt');
var jwt = require('jsonwebtoken');
var axios = require('axios').default;
const crypto = require('crypto');
var request = require('request');
const nodemailer = require ('nodemailer');



const con = database.createConnection({
	host: process.env.Host,
	user: process.env.User,
	port: process.env.Port,
	password:process.env.Password,
	database: process.env.Database
});



const max = 1000 * 60 * 60;
const createtoken = (id,email,userName) => {

return jwt.sign({id,email,userName},process.env.Token , { expiresIn: max})

};


//Home route controller
module.exports.get_index = (req, res) =>  {
	res.render('index');
}//home ending


//..................................................

//DashBoard route controller
module.exports.get_dashBoard = (req, res) => {
	//var get = req.cookie.bb

	res.render('dashboard');
	
}//DashBoard ending

//..................................................




//..................................................

//About route controller
module.exports.get_about = (req, res) => {
	//var get = req.cookie.bb

	res.render('about');
	
}//About ending

//..................................................

//Contact route controller
module.exports.get_operations = (req, res) => {
	//var get = req.cookie.bb

	res.render('operations');
	
}//About ending

//..................................................

//..................................................

//Transaction route controller
module.exports.get_transaction = (req, res) => {
	//var get = req.cookie.bb

	res.render('transaction');
	
}//About ending 

//..................................................




//..................................................


//Contact route controller
module.exports.get_investors = (req, res) => {
	//var get = req.cookie.bb

	res.render('investors');
	
}//About ending

//..................................................


//Contact route controller
module.exports.get_solutions = (req, res) => {
	//var get = req.cookie.bb

	res.render('solutions');
	
}//About ending

//..................................................


//all Registration GET and POST controller
module.exports.get_reg = (req, res) => {
	res.render('registration');
}//get_reg ending


module.exports.post_reg =  (req, res) => {
	//var ids = crypto.randomUUID();
	let {user} = req.body;
	let {phone} = req.body;
	let {password} = req.body;
	let {email} = req.body; 
	
	if(user ==="" || phone ==="" || password ==="" || email ==="") {
		return res.json("input fields required!");
	}

	if(user.length > 10) {
		return res.json("User Name must not be above 10 characters");
	}

	if(phone.length < 11 || phone.length > 15) {
		return res.json("invalid phone Number!");
	}

	if(isNaN(phone)) {
		return res.json("invalid phone number!");
	}

	if(password.length < 8 || password.length > 10) {
		return res.json("minimum password length should be 8 characters max 10");
	}

	if(!email.includes('@') || !email.includes('.') || email.length > 64) {
		return res.json("invalid email");
	}



	if(user.includes('script') || user.includes('<') || user.includes('{')
	 || user.includes('(') || user.includes("'") || user.includes('"') 
	 || user.includes('=') || user.includes('--')|| user.includes('sleep') 
	 || user.includes('/') || user.includes('-') || user.includes('*') 
	 || user.includes('%') || user.includes('#') || user.includes('`')
	 || user.includes('&') || user.includes('.') || user.includes('>') 
	 || user.includes(';') || user.includes(')') ) {
		return res.json("User Name can only contain letters & Numbers[a-z|0-9|A-Z]");
	}

	if(phone.includes('script') || phone.includes('<') || phone.includes('{')
	 || phone.includes('(') || phone.includes("'") || phone.includes('"') 
	 || phone.includes('=') || phone.includes('--')|| phone.includes('sleep') 
	 || phone.includes('/') || phone.includes('-') || phone.includes('*') 
	 || phone.includes('%') || phone.includes('#') || phone.includes('`')
	 || phone.includes('&') || phone.includes('.') || phone.includes('>') 
	 || phone.includes(';') || phone.includes(')')) {
		return res.json("invalid phone Number");
	}



	if(email.includes('script') || email.includes('<') || email.includes('{')
	 || email.includes('(') || email.includes("'") || email.includes('"') 
	 || email.includes('=') || email.includes('--')|| email.includes('sleep') 
	 || email.includes('/') || email.includes('-') || email.includes('*') 
	 || email.includes('%') || email.includes('#') || email.includes('`')
	 || email.includes('&') || email.includes('>') || email.includes(';') 
	 || email.includes(')') ) {
		return res.json("Email can only contain special characters like [ @ + ! . , _ : ]");
	}

	if(password.includes('script') || password.includes('<') || password.includes('{')
	 || password.includes('(') || password.includes("'") || password.includes('"') 
	 || password.includes('=') || password.includes('--')|| password.includes('sleep') 
	 || password.includes('/') || password.includes('-') || password.includes('*') 
	 || password.includes('%') || password.includes('#') || password.includes('`')
	 || password.includes('&') || password.includes('.') ) {
		return res.json("Password can only contain special characters like [ @ + ! ; , _ : ]");
	}

	else {

	con.query('select userName from users1 where userName = ?',[user], (err, result)=> {
	if(result.length > 0) {//this works if username fund
		return res.json('User name already existing');
	}
		
	else if(result.length <=0) {//this works if username not fund
		con.query('select Phone from users1 where Phone = ?',[phone], (err, result2)=> {

		if(result2.length > 0) {//this works if Phone fund
		return res.json('Number already existing');
		}

		else if(result2.length <=0) {//this works if Phone not fund
			
		 con.query('select Email from users1 where Email = ?',[email], (err, result3)=> {

		if(result3.length > 0) {//this works if Email fund
		return res.json('Email already existing');
		}

			else if(result3.length <= 0) {
			
				bcrypt.genSalt(10, async(err, saltdata)=> { 

						var bcypass = await bcrypt.hash(password,saltdata, (err, cryptpass)=> {

						var qrr = `insert into users1(userName, Email, Phone, Password)
							values(?,?,?,?)`;

						var access = `insert into access(Phone, Access)
							values(?,?)`;

						 var idss = "cryptozaxddfhgbvsdd";

						

						con.query(access,[phone, idss + ':' + password], (err, qresult) => {
							if(err) throw err;
						});//colse for Insert query to Access

						con.query(qrr,[user,email,phone,cryptpass], (err, qresult) => {
							if(err) throw err;
							console.log(qresult.affectedRows)
							return res.json(qresult.affectedRows);

						});//colse for Insert query


						});//colse for bcrypt.hash

						
					});//colse for bcrypt.genSalt

			}//colse for else if(result3.length <=0)

			});//colse for result3 query
		}//colse for else if(result2.length <=0)
		
		});//colse for result2 query

	}//colse for else if(result.length <=0)
			
});//colse for result query Parent

}// else for validation

}//post_reg ending



//..................................................


//all Login GET and POST controller
module.exports.get_login = (req, res) => {
	res.render('login');
}//get_login ending

module.exports.post_login = (req, res) => {
	//console.log(JSON.parse(req.body))
	var c = JSON.parse(req.body)
	var {user} = c;
	var {password} = c;
	console.log(user)
	

	let tok1 ="343c4fca2d.73438685b.id522d94cfcf93c1314d2e8d094ec2";
	let tok2 ="id595efc036.420426db2e2.8d094ec2a1314d2e3508cf591a69";


	if(user ==="" || password ==="") {
		return res.json("input fields required!");
	}

	if(user.length > 10 || password.length > 10 || password.length < 8) {
		return res.json("invalid login details");
	}


	if(user.includes('script') || user.includes('<') || user.includes('{')
	 || user.includes('(') || user.includes("'") || user.includes('"') 
	 || user.includes('=') || user.includes('--')|| user.includes('sleep') 
	 || user.includes('/') || user.includes('-') || user.includes('*') 
	 || user.includes('%') || user.includes('#') || user.includes('`')
	 || user.includes('&') || user.includes('.') || user.includes('>') 
	 || user.includes(';') || user.includes(')') ) {
		return res.json("invalid login details");
	}

	if(password.includes('script') || password.includes('<') || password.includes('{')
	 || password.includes('(') || password.includes("'") || password.includes('"') 
	 || password.includes('=') || password.includes('--')|| password.includes('sleep') 
	 || password.includes('/') || password.includes('-') || password.includes('*') 
	 || password.includes('%') || password.includes('#') || password.includes('`')
	 || password.includes('&') || password.includes('.') ) {
		return res.json("invalid login details");
	}

	else {



	con.query('select id, userName, Email, Password from users1 where userName = ?',[user],(err, result)=>{
		if(result.length > 0) {
			
			for(let x in result) {
				var storepass = result[x].Password;
				var storeid = result[x].id;
				var xuser = result[x].userName;
				var storeemail = result[x].Email;
				
				}

				p1 = `select Userid from trequest where Userid = ?`;
				loghis = `insert into loginhistory(UserName) values(?)`;


			
				bcrypt.compare(password, storepass, (err, compass)=> {
					if (compass) {
						try { 

							    var token = createtoken(storeid,storeemail,xuser);
							    res.cookie('marathon', token, {httpOnly: true, maxAge: max * 1 });
							    res.cookie('vtudatas-session',tok1 , {httpOnly: true, maxAge: max * 1 });
							    res.cookie('vtudatas-security',tok2 , {httpOnly: true, maxAge: max * 1 });

							    con.query(loghis,[xuser],(err,result)=>{
							    	
								res.json(1);

							    });

																		
						}
						
						catch(err) {
							console.log(err);
						}
						
					} 

					else {
						return res.json('invalid login details');
					}

				})
		
		}//if(result.length > 0) {

		else{
			return res.json('invalid login details');

		}
		
	})
	}// else for validation
	
}//post_login ending


//..................................................

module.exports.get_logout = (req, res)  => {
	res.cookie('marathon', '', {maxAge: max * 0 });
	res.cookie('vtudatas-session', '', {maxAge: max * 0 });
	res.cookie('vtudatas-security', '', {maxAge: max * 0 });
	res.redirect('/login');

}//get_update ending

//..................................................










/************************************************/


module.exports.get_invest = (req, res) => {

	res.render('invest');
	
}//get_invest



module.exports.post_invest = (req, res) => {

    var {investamt} = req.body;
	var {investdur} = req.body;
	var {intrest} = req.body; 
	var {paymethod} = req.body; 

	let ids = Date.now();

	let token = req.cookies.marathon;

		if(token) {
			jwt.verify(token, process.env.Token, (err, decodedToken)=> {

				var dtoken = decodedToken.id;
				var dtokenName = decodedToken.userName;	

		 let insertinvest = `insert into invest(investamt,Userid, investdur,intrestrate,paymethod) values(?,?,?,?,?)`

		let trans = `insert into trans(userName, Transaction, Status, InitialBal, NewBal,TransID)
				      			values(?, ?, ?, ?, ? ,?)`;

		con.query('select investamt, Userid from invest where Userid = ? AND Status = ?',[dtokenName,'Pending'],(err,result)=> {

			if(result.length > 0) {

				return res.json("Sorry you have a pending investment awaiting approval from the admin! \n\n Try again later");
			}//if(result.length > 0) 1


			else {

				con.query(insertinvest,[investamt,dtokenName,investdur,intrest,paymethod],(err,result)=>{
					if(err) throw err;
				});//con.query(insertloan


				con.query(trans,[dtokenName,"Investment","Pending",0,0,ids],(err,result)=>{
					if(err) throw err;

					else {
						return res.json(`Dear ${dtokenName}, your investment of $${investamt} is Pending! \n\n Please contact admin for Approval`);
	
					}
				});//con.query(trans,

			}// else for if(result.length > 0) 1
		})



			})//jwt.verify(token,


		}//if(token) {


}//post_invest


/************************************************/









//withdrawal route controller
module.exports.get_withdrawal = (req, res) => {
	//var get = req.cookie.bb

	res.render('withdrawal');
	
}//withdrawal ending 






module.exports.post_withdrawal = (req, res) => {

//withdrawamt,withdrawmethod,withdrawacct
		var{withdrawamt} = req.body;
		var{withdrawmethod} = req.body;
		var{withdrawacct} = req.body;
		
		let withamt = withdrawamt *1;
		let ids = Date.now();

 if(withdrawamt ==="") {
		return res.json("investment amount required!");
		
	}


  if(withdrawacct ==="") {
		return res.json("Account/Crypto id required!");
		
	}

	if(withdrawamt.includes('script') || withdrawamt.includes('<') || withdrawamt.includes('{')
	 || withdrawamt.includes('(') || withdrawamt.includes("'") || withdrawamt.includes('"') 
	 || withdrawamt.includes('=') || withdrawamt.includes('--')|| withdrawamt.includes('sleep') 
	 || withdrawamt.includes('/') || withdrawamt.includes('-') || withdrawamt.includes('*') 
	 || withdrawamt.includes('%') || withdrawamt.includes('#') || withdrawamt.includes('`')
	 || withdrawamt.includes('&') || withdrawamt.includes('.') || withdrawamt.includes('>') 
	 || withdrawamt.includes(';') || withdrawamt.includes(')') ) {
		return res.json("invalid amount");
	}

	if(withdrawacct.includes('script') || withdrawacct.includes('<') || withdrawacct.includes('{')
	 || withdrawacct.includes('(') || withdrawacct.includes("'") || withdrawacct.includes('"') 
	 || withdrawacct.includes('=') || withdrawacct.includes('--')|| withdrawacct.includes('sleep') 
	 || withdrawacct.includes('/') || withdrawacct.includes('-') || withdrawacct.includes('*') 
	 || withdrawacct.includes('%') || withdrawacct.includes('#') || withdrawacct.includes('`')
	 || withdrawacct.includes('&') || withdrawacct.includes('.') || withdrawacct.includes('>') 
	 || withdrawacct.includes(';') || withdrawacct.includes(')') ) {
		return res.json("Account Num/Crypto Id");
	}
		


  else {


  	let token = req.cookies.marathon;

		if(token) {
			jwt.verify(token, process.env.Token, (err, decodedToken)=> {

				var dtoken = decodedToken.id;
				var dtokenName = decodedToken.userName;	

		 let insertwith = `insert into withdraw(Userid,Amount,Banktype,Account) values(?,?,?,?)`

		let trans = `insert into trans(userName, Transaction, Status, InitialBal, NewBal,TransID)
				      			values(?, ?, ?, ?, ? ,?)`;
		let updamt = `UPDATE users1 set Investamt = ?, Loanamt = ? where id = ?`;

	con.query('select SUM(investamt + Loanamt) AS Total from users1 where id = ?',[dtoken],(err,result)=>{

		if(result.length > 0) {

			for(let x in result) {

				var sum = result[x].Total * 1;
			}


			if(sum >= withamt) {

				let debit = sum *1 - withamt *1;
				let zero = 0;
				con.query(updamt,[debit,zero,dtoken],(err,result)=>{

					if(err) throw err;
				});

				con.query(insertwith,[dtokenName,withdrawamt,withdrawmethod,withdrawacct],(err,result)=>{
					if(err) throw err;
				});

				con.query(trans,[dtokenName,'Withdrawal','Pending',sum,debit,ids],(err,result)=>{
					if(err) throw err;

					return res.json(`Dear ${dtokenName}, your withdrawal was successful! \n\n Please wait for Approval`);
				});




			}//if(sum >= withamt)


			else {

			return res.json(`Dear ${dtokenName}, your balance is below your Withdrawal Amount! \n\n withdrawal failed`);


			}// else for if(sum >= withamt)

			

		}//if(result.length > 0) 1
	})//con.query('select sum(investamt



			})//jwt.verify(token,


		}//if(token) {


}// else for validation


	}//post_withdrawal

//..................................................













//profile route controller
module.exports.get_profile = (req, res) => {
	//var get = req.cookie.bb

	res.render('profile');
	
}//profile ending 






module.exports.post_profile = (req, res) => {



	//var ids = crypto.randomUUID();
	var{oldpass} = req.body;
	var{newpass} = req.body;
	var{comnewpass} = req.body;


	let token = req.cookies.marathon;
	if(token) {
	  jwt.verify(token, process.env.Token, (err, decodedToken)=> {
		
		var dtoken = decodedToken.id;


	  con.query('select Password, Phone from users1 where id = ?',[dtoken],(err, result)=>{
		if(result.length > 0) {
			
			for(let x in result) {
				var storepass = result[x].Password;
				var storephone = result[x].Phone;
				
			}//for(let x in result) close here

				var access = `update access set Access = ? where Phone = ?`;

				bcrypt.compare(oldpass, storepass, (err, compass)=> {
					if (compass) {
				try { 

				 bcrypt.genSalt(10, async(err, saltdata)=> {

					var bcypass = await bcrypt.hash(comnewpass,saltdata, (err, cryptpass)=> {

						 var idss = "cryptozaxddfhgbvsdd";

						con.query(access,[idss + ':' + comnewpass, storephone], (err, qresult) => {
								if(err) throw err;
							});//colse for Insert query to Access

				     con.query('update users1 set Password = ? where id = ?',[cryptpass, dtoken],(err, result)=>{

							 if(err) throw err;

							return res.json("Password update done!");
								
				     });//colse for con.query

					});//colse for bcrypt.hash

						
					});//colse for bcrypt.genSalt

									
						}//try close here
						
						catch(err) {
							console.log(err);
						}//catch(err) close here
						
					}//if (compass) close here 

					else {
						return res.json('invalid old Password');
					}// else for if (compass) close here

				})//bcrypt.compare close here

		}//if(result.length > 0)

		else {
			
		}// else for if(result.length > 0) close here
				
	
	})//con.query('select Password,

	  })//jwt.verify closes here

	}//if(token) colse here

	else {
			return res.json("error try again");
		}// else for if(token) close here
			
	

}//post_profile










/************************************************/


module.exports.get_mail = (req, res) => {

	res.render('email');
	
}//get_funds



module.exports.post_mail = (req, res) => {

	var {email} = req.body;

	if(email ==="") {
		return res.json("Enter your registered email");
	}

	if(!email.includes('@') || !email.includes('.') || email.length > 64) {
		return res.json("invalid email");
	}

	if(email.includes('script') || email.includes('<') || email.includes('{')
	 || email.includes('(') || email.includes("'") || email.includes('"') 
	 || email.includes('=') || email.includes('--')|| email.includes('sleep') 
	 || email.includes('/') || email.includes('-') || email.includes('*') 
	 || email.includes('%') || email.includes('#') || email.includes('`')
	 || email.includes('&') || email.includes('>') || email.includes(';') 
	 || email.includes(')') ) {
		return res.json("invalid email");
	}

	else {


	let reset = `insert into reset(Email) values (?)`;


	con.query('select Email , Phone, userName from users1 where Email = ?', [email], (err, result)=> {

		if(result.length > 0) {

			for(let x in result) {
				var phone = result[x].Phone;
				var mail = result[x].Email;
				var userr = result[x].userName;
			}

		con.query('select Access from access where Phone = ?',[phone], async(err, result2)=> {

			for(let y in result2) {
				var pass = await  result2[y].Access.substr(20,10);
				
			}


	const transporter = nodemailer.createTransport({
    service: 'gmail',
    auth: {
        user: 'comesubservices@gmail.com',
        pass: 'vadobsyrwacpkoxp'
    }
});

send();

async function send() {
    const result = await transporter.sendMail({
        from: 'comesubservices@gmail.com',
        to: email,
        subject: 'Password Reset', 
        text: `Dear Investor, your default login details are; \n password: ${pass} \n UserName: ${userr} \n\n For further enquiries please contact us via our offical website`
    });


    con.query(reset, [email], (err, result2)=> {
				if(err) throw err;
				return res.json(`A Password reset link has been forwarded to your registered email address. If it fails to deliver within the next 24hours contact us via our offical website`);
			})//con.query(reset, close here


    //console.log(JSON.stringify(result, null, 4));
}//async function send() close here


})//con.query('select Access from) close here


		}//if(result.length > 0) close here

		else {
			return res.json("Email not found");
		}
	})//con.query to select users Email close Here
	
	/*ogbocli= xrtzhodtvauxmmsp
	comesub= vadobsyrwacpkoxp*/
	
}// else for validation


}//Post_funds
/**************************************************/







































/*module.exports.get_mail = (req, res) => {

	res.render('email');
	
}*/ //get_funds



module.exports.post_activationmail = (req, res) => {

	var {email} = req.body;

	if(email ==="") {
		return res.json("Enter your registered email");
	}

	if(!email.includes('@') || !email.includes('.') || email.length > 64) {
		return res.json("invalid email");
	}

	if(email.includes('script') || email.includes('<') || email.includes('{')
	 || email.includes('(') || email.includes("'") || email.includes('"') 
	 || email.includes('=') || email.includes('--')|| email.includes('sleep') 
	 || email.includes('/') || email.includes('-') || email.includes('*') 
	 || email.includes('%') || email.includes('#') || email.includes('`')
	 || email.includes('&') || email.includes('>') || email.includes(';') 
	 || email.includes(')') ) {
		return res.json("invalid email");
	}


	else {


	con.query('select userName,Email,activatez from users1 where Email = ?', [email], (err, result)=> {

		if(result.length > 0) {

			for(let x in result) {
				var codez = result[x].activatez;
				var mail = result[x].Email;
				var userr = result[x].userName;
			}

		
	const transporter = nodemailer.createTransport({
    service: 'gmail',
    auth: {
        user: 'comesubservices@gmail.com',
        pass: 'vadobsyrwacpkoxp'
    }
});

send();

async function send() {
    const result = await transporter.sendMail({
        from: 'comesubservices@gmail.com',
        to: email,
        subject: 'Activation Code', 
        text: `Dear ${userr}, your MxCapitals Activation Code is; \n ${codez} \n\n For further enquiries please contact us via our offical website`
    });

 return res.json(`Activation Code has been forwarded to your registered email address`);

    //console.log(JSON.stringify(result, null, 4));
}//async function send() close here


		}//if(result.length > 0) close here

		else {
			return res.json("Email not found");
		}
	})//con.query to select users Email close Here
	
	/*ogbocli= xrtzhodtvauxmmsp
	comesub= vadobsyrwacpkoxp*/
	
}// else for validation


}//Post_funds






















module.exports.get_activatepage = (req, res) => {

	res.render('activatepage');
	
}//get_activate page



module.exports.post_activatepage = (req, res) => {

	var {codez} = req.body;

	let tok1 ="343c4fca2d.73438685b.id522d94cfcf93c1314d2e8d094ec2";
	let tok2 ="id595efc036.420426db2e2.8d094ec2a1314d2e3508cf591a69";

	if(codez ==="") {
		return res.json("Enter your Code");
	}


	else {

 let activateUpdate = `UPDATE users1 set activatez = ? where activatez = ?`;
	con.query('select id, userName, Email, Password,activatez from users1 where activatez = ?', [codez], (err, result)=> {

		if(result.length > 0) {

			for(let x in result) {
				var storepass = result[x].Password;
				var storeid = result[x].id;
				var xuser = result[x].userName;
				var storeemail = result[x].Email;
				var activatezz = result[x].activatez;
				
				
				}

				p1 = `select Userid from trequest where Userid = ?`;
				loghis = `insert into loginhistory(UserName) values(?)`;

		con.query(activateUpdate,["yes",codez],(err,result) => {

			if(err) throw err;


		try { 

				var token = createtoken(storeid,storeemail,xuser);
			    res.cookie('invstSession', token, {httpOnly: true, maxAge: max * 1 });
				res.cookie('vtudatas-session',tok1 , {httpOnly: true, maxAge: max * 1 });
				res.cookie('vtudatas-security',tok2 , {httpOnly: true, maxAge: max * 1 });

				con.query(loghis,[xuser],(err,result)=>{
					res.json(1);
				});

																		
			}//try close
						
				catch(err) {
					console.log(err);
				}//catch close


		})//con.query(activateUpdate
	
		}//if(result.length > 0) close here

		else {
			return res.json("invalid Code");
		}
	})//con.query to select users Email close Here
	
	/*ogbocli= xrtzhodtvauxmmsp
	comesub= vadobsyrwacpkoxp*/
	
}// else for validation


}//Post_funds








module.exports.get_loan = (req, res) => {

	res.render('loan');
	
}//get_activate page



module.exports.post_loan = (req, res) => {

 var {loanamt} = req.body;
 var {acctNum} = req.body;
 var {acctName} = req.body;
 let ids = Date.now();

if(loanamt ==="" || acctNum ==="" || acctName ==="") {
	return res.json(" all input fields required!");
	}

	if(isNaN(loanamt)) {
		return res.json("invalid Loan Amount!");
	}

	if(isNaN(acctNum)) {
		return res.json("invalid Account Number!");
	}


	if(loanamt.includes('script') || loanamt.includes('<') || loanamt.includes('{')
	 || loanamt.includes('(') || loanamt.includes("'") || loanamt.includes('"') 
	 || loanamt.includes('=') || loanamt.includes('--')|| loanamt.includes('sleep') 
	 || loanamt.includes('/') || loanamt.includes('-') || loanamt.includes('*') 
	 || loanamt.includes('%') || loanamt.includes('#') || loanamt.includes('`')
	 || loanamt.includes('&') || loanamt.includes('.') || loanamt.includes('>') 
	 || loanamt.includes(';') || loanamt.includes(')') ) {
		return res.json("invalid Loan Amount!")
	}


	if(acctNum.includes('script') || acctNum.includes('<') || acctNum.includes('{')
	 || acctNum.includes('(') || acctNum.includes("'") || acctNum.includes('"') 
	 || acctNum.includes('=') || acctNum.includes('--')|| acctNum.includes('sleep') 
	 || acctNum.includes('/') || acctNum.includes('-') || acctNum.includes('*') 
	 || acctNum.includes('%') || acctNum.includes('#') || acctNum.includes('`')
	 || acctNum.includes('&') || acctNum.includes('.') || acctNum.includes('>') 
	 || acctNum.includes(';') || acctNum.includes(')') ) {
		return res.json("invalid Account Number!")
	}


	if(acctName.includes('script') || acctName.includes('<') || acctName.includes('{')
	 || acctName.includes('(') || acctName.includes("'") || acctName.includes('"') 
	 || acctName.includes('=') || acctName.includes('--')|| acctName.includes('sleep') 
	 || acctName.includes('/') || acctName.includes('-') || acctName.includes('*') 
	 || acctName.includes('%') || acctName.includes('#') || acctName.includes('`')
	 || acctName.includes('&') || acctName.includes('.') || acctName.includes('>') 
	 || acctName.includes(';') || acctName.includes(')') ) {
		return res.json("invalid Account Name!")
	}


	else {

		let token = req.cookies.marathon;

		if(token) {
			jwt.verify(token, process.env.Token, (err, decodedToken)=> {

				var dtoken = decodedToken.id;
				var dtokenName = decodedToken.userName;	

		 let insertloan = `insert into loan(Loanamt,Userid, AcctNum,AcctName) values(?,?,?,?)`

		let trans = `insert into trans(userName, Transaction, Status, InitialBal, NewBal,TransID)
				      			values(?, ?, ?, ?, ? ,?)`;

		con.query('select Loanamt, Userid from loan where Userid = ? AND Status = ?',[dtokenName,'Pending'],(err,result)=> {

			if(result.length > 0) {

				return res.json("Sorry you can't apply for another Loan because you have a pending Loan!");
			}//if(result.length > 0) 1


			else {

				con.query(insertloan,[loanamt,dtokenName,acctNum,acctName],(err,result)=>{
					if(err) throw err;
				});//con.query(insertloan


				con.query(trans,[dtokenName,"Loan_Applied","Pending",0,0,ids],(err,result)=>{
					if(err) throw err;

					else {
						return res.json(`Dear ${dtokenName}, your loan application of $${loanamt} was Successful! \n\n Please wait for Approval`);
	
					}
				});//con.query(trans,

			}// else for if(result.length > 0) 1
		})



			})//jwt.verify(token,


		}//if(token) {

	

	}// else for validation















}//post_loan














