
require('dotenv').config();
//process.env.Token
var database = require('mysql');
var jwt = require('jsonwebtoken');

const con = database.createConnection({
	host: process.env.Host,
	user: process.env.User,
	port: process.env.Port,
	password:process.env.Password,
	database: process.env.Database
});


function authentdash(req , res, next) {
	var token = req.cookies.marathon;
	if(token) {

		jwt.verify(token, process.env.Token, (err, decodedToken)=> {

			if(err) {
				throw err
				res.redirect('/login');

			}

			else {
				//console.log(decodedToken);
				next();
			}
		})

	}

	else {

		res.redirect('/login');
	}
}


//*********This is for Displaying User Record****/
function loc(req,res,next) {
	var token = req.cookies.marathon;
	if(token) {

		jwt.verify(token, process.env.Token, (err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}


			else {
				var dtoken = decodedToken.id;
			
			con.query('select userName,Email,Phone,Investamt,Loanamt,RegDate,Status,id from users1 where id = ?', [dtoken], (err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
				for(let y in result) {
					var userinfo = result[y];

				}
				
				res.locals.userr = userinfo ;
				next();	
				
				}

				else {
					res.locals.userr = "0";
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}







//*********This is for Displaying User Total Balance Record****/
function Bal(req,res,next) {
	var token = req.cookies.marathon;
	if(token) {

		jwt.verify(token, process.env.Token, (err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}


			else {
				var dtoken = decodedToken.id;
			
			con.query('select SUM(Investamt + Loanamt) AS Total from users1 where id = ?', [dtoken], (err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
				for(let y in result) {
					var userinfo = result[y];

				}

				
				
				res.locals.bal = userinfo ;
				next();	
				
				}

				else {
					res.locals.bal = "0";
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}






//*****************************This is for Transaction count on dashbord****/
function trn(req,res,next) {
	var token = req.cookies.marathon;
	if(token) {

		jwt.verify(token, process.env.Token, (err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.userName;
			
			con.query('select count(status) from trans where userName  = ?', [dtoken], (err, result)=>{

				if(result.length > 0) {

					for(let x in result) {
						//console.log(result[x]['SUM(Userid)']);
					var rowsum = result[x]['count(status)'];
					}
				
				res.locals.trnrec = rowsum ;
				next();	
				
				}

				else {
					res.locals.trnrec = "0";
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}







//*****************************This is for Reserved Account on dashbord****/
function reservedAcct(req,res,next) {
	var token = req.cookies.marathon;
	if(token) {

		jwt.verify(token, process.env.Token, (err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.email;

				var chng = dtoken.toString();

				console.log(chng);
			
			con.query('select Email,AcctNum,AcctName,Bank from reservedaccount where Email = ?', [chng], (err, result)=>{

				if(result.length > 0) {

					for(let x in result) {
						//console.log(result[x]['SUM(Userid)']);
					var rowsums = result[x];
					}
				
				res.locals.resevedacct = rowsums ;
				next();	
				
				}

				else {
					res.locals.resevedacct = "0";
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}








//*****************************This is for Transaction Record Table****/


function tabletran(req,res,next) {
	var token = req.cookies.marathon;
	if(token) {

		jwt.verify(token, process.env.Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.userName;
				
			
			con.query('select * from trans where userName = ? order by id desc limit 20', [dtoken], (err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

			
				
				res.locals.tabtrns = userinfo ;
				next();	
				
				}

				else {
					res.locals.tabtrns =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}



/***********************************Admin Starts Here*********************/

function adminauthent(req , res, next) {
	var token = req.cookies.admincook;
	if(token) {

		jwt.verify(token, process.env.Admin_Token, (err, decodedToken)=> {

			if(err) {
				throw err
				res.redirect('/login');

			}

			else {
				//console.log(decodedToken);
				next();
			}
		})

	}

	else {

		res.redirect('/login');
	}
}


//*********Admin Protected Routes Ends Here****/


//*****************************This is for Transaction Record Table****/



function admintab1(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from users1 order by id desc',(err, result)=>{

				if(result.length >0) {
					console.log(result)
				
					var userinfo = result;

				
				
				res.locals.admintrans = userinfo ;
				next();	
				
				}

				else {
					res.locals.admintrans =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}
/******************Admin Registered Users Ends Here*****/






function adminair2cash(req,res,next) {
	var token = req.cookies.admincook;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from air2cash order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminair2cash = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminair2cash =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}
/******************Admin AirTime2Cash Users Ends Here*****/









function adminshare(req,res,next) {
	var token = req.cookies.admincook;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from share order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminshare = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminshare =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}
/******************Admin Share And Sell Ends Here*****/









function adminsms(req,res,next) {
	var token = req.cookies.admincook;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from sms order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminsms = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminsms =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}

/******************Admin SMS Ends Here*****/








/******************Admin SMS Ends Here*****/



function adminuserbal(req,res,next) {
	var token = req.cookies.admincook;
	if(token) {

		jwt.verify(token, process.env.Admin_Token, (err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
			
			con.query('select sum(Amount) from users1', (err, result)=>{

				if(result.length > 0) {

					for(let x in result) {
						//console.log(result[x]['SUM(Userid)']);
					var rowsum = result[x]['sum(Amount)'];
					}
				
				res.locals.adminuserbal = rowsum ;
				next();	
				
				}

				else {
					res.locals.adminuserbal = "0";
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}










































/******************Admin User Balance Ends Here*****/





/************************************Admin Starts Here*********************/

function adminauthent(req , res, next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token, (err, decodedToken)=> {

			if(err) {
				throw err
				res.redirect('/adminlog');

			}

			else {
				//console.log(decodedToken);
				next();
			}
		})

	}

	else {

		res.redirect('/login');
	}
}


/*********Admin Protected Routes Ends Here****/


/*****************************This is for Transaction Record Table****/


function admintab1(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from users1 order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.admintrans = userinfo ;
				next();	
				
				}

				else {
					res.locals.admintrans =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}
/******************Admin Registered Users Ends Here*****/








function adminwithdraw(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from withdraw order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminwithdraw = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminwithdraw =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}













function adminloan(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from loan order by id desc',(err, result)=>{

				if(result.length > 0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminloan = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminloan =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}






function admininvest(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from invest order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.admininvest = userinfo ;
				next();	
				
				}

				else {
					res.locals.admininvest =userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}

/******************Admin Withdrawal Ends Here*****/






function admintransaction(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from trans order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

			
				
				res.locals.admintransaction = userinfo ;
				next();	
				
				}

				else {
					res.locals.admintransaction = userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}





function adminaccess(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from access order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminaccess = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminaccess = userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}








/******************Admin Access Ends Here*****/

function adminreset(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from reset order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminreset = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminreset = userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}

/***************** Admin Reset End Here******/


function adminretailers(req,res,next) {
	var token = req.cookies.admincook;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from Retailers order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminretailers = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminretailers = userinfo;
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}

/***************** Admin Login History Starts Here******/

function adminloghis(req,res,next) {
	var token = req.cookies.adminmarathon;
	if(token) {

		jwt.verify(token, process.env.Admin_Token,(err, decodedToken)=> {

			if(err) {
				throw err;
				next();
			}

			else {
				var dtoken = decodedToken.id;
				
			
			con.query('select * from loginhistory order by id desc',(err, result)=>{

				if(result.length >0) {
					//console.log(result)
				
					var userinfo = result;

				
				
				res.locals.adminloghis = userinfo ;
				next();	
				
				}

				else {
					res.locals.adminloghis  = userinfo;
					console.log("result")
				next();	
				}

			})
				
			}

		})
			
}

	else {
		next();
	}
}






module.exports = {
	authentdash,
	loc,
	Bal,
	tabletran,
	trn,
	adminloghis,

	
	reservedAcct,
	//Admin own starts here
	adminauthent,
	admintab1,
	adminair2cash,
	adminshare,
	adminwithdraw,
	adminsms,
	admintransaction,
	adminuserbal,
	adminaccess,
	adminreset,
	adminretailers,
	adminloan,
	admininvest
	
}




